{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitXupaXups;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, MMSystem;

const
  MaximPosicionsViatge = 2048;

type
  TFormXupaXups = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCaixaEines: TSpeedButton;
    CheckBoxLiniesAlMateixLLoc: TCheckBox;
    SpeedButtonEngegarPararGlobus: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure SpeedButtonEngegarPararGlobusClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    PosicioPrimeraLinia, PosicioSegonaLinia:integer;
    ValorDetectat:integer;
    CircuitXupaXups:array[0..1,0..MaximPosicionsViatge] of boolean;
    HiHaXupaXups:boolean;
    ComptadorPosicio:integer;
    procedure PintarIntensitat;
  end;

var
  FormXupaXups: TFormXupaXups;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitEntradaSo, UnitCanviDeparametres, UnitTools;

{$R *.DFM}

procedure TFormXupaXups.FormCreate(Sender: TObject);
var
  i,n:integer;
begin
  Top:=0;
  Left:=0;
  Width:=Screen.Width;
  ClientHeight:=Panel.Height+10+128+128;
  for i:=0 to MaximPosicionsViatge do for n:=0 to 1 do CircuitXupaXups[n,i]:=false;
  ValorDetectat:=0;
  PosicioPrimeraLinia:=Panel.Height+128;
end;

procedure TFormXupaXups.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormXupaXups.FormPaint(Sender: TObject);
var
  i:integer;
begin
  PintarIntensitat;
  Canvas.Pen.Color:=clBlue;
  Canvas.Brush.Color:=clGreen;
  Canvas.MoveTo(0,PosicioPrimeraLinia);
  Canvas.LineTo(ClientWidth,PosicioPrimeraLinia);
  for i:=0 to MaximPosicionsViatge do begin
    if CircuitXupaXups[0,i] then begin
      Canvas.MoveTo(i,PosicioPrimeraLinia);
      Canvas.LineTo(i,PosicioPrimeraLinia-64);
      Canvas.Ellipse(i-4,PosicioPrimeraLinia-64-4,i+4,PosicioPrimeraLinia-64+4)
    end;
  end;
  if CheckBoxLiniesAlMateixLLoc.Checked then PosicioSegonaLinia:=Panel.Height+128 else PosicioSegonaLinia:=Panel.Height+256;
  Canvas.Pen.Color:=clBlack;
  Canvas.Brush.Color:=clRed;
  Canvas.MoveTo(0,PosicioSegonaLinia);
  Canvas.LineTo(ClientWidth,PosicioSegonaLinia);
  for i:=0 to MaximPosicionsViatge do begin
    if CircuitXupaXups[1,i] then begin
      Canvas.MoveTo(i,PosicioSegonaLinia);
      Canvas.LineTo(i,PosicioSegonaLinia-64);
      Canvas.Ellipse(i-4,PosicioSegonaLinia-64-4,i+4,PosicioSegonaLinia-64+4)
    end;
  end;
end;

procedure TFormXupaXups.PintarIntensitat;
const
  y = 20;
var
  i,max:integer;
begin
  Canvas.Pen.Color:=RGB(128,0,0);
  Canvas.MoveTo(0,20+y);
  Canvas.LineTo(ValorMinim,20+y);
  Canvas.MoveTo(0,35+y);
  Canvas.LineTo(ValorMinim,35+y);
  i:=0;
  while i<=ValorMinim do begin
    Canvas.MoveTo(i,20+y);
    Canvas.LineTo(i,23+y);
    Canvas.MoveTo(i,35+y);
    Canvas.LineTo(i,32+y);
    i:=i+10;
  end;
  Canvas.Pen.Color:=RGB(0,128,0);
  Canvas.MoveTo(ValorMinim,20+y);
  Canvas.LineTo(ValorMaxim,20+y);
  Canvas.LineTo(ValorMaxim,35+y);
  Canvas.LineTo(ValorMinim,35+y);
  Canvas.LineTo(ValorMinim,20+y);
  while i<=ValorMaxim do begin
    Canvas.MoveTo(i,20+y);
    Canvas.LineTo(i,23+y);
    Canvas.MoveTo(i,35+y);
    Canvas.LineTo(i,32+y);
    i:=i+10;
  end;
  max:=128;
  if ValorMaxim<max then begin
    Canvas.Pen.Color:=RGB(128,0,0);
    Canvas.MoveTo(ValorMaxim,20+y);
    Canvas.LineTo(Max,20+y);
    Canvas.LineTo(Max,35+y);
    Canvas.LineTo(ValorMaxim,35+y);
    while i<=Max do begin
      Canvas.MoveTo(i,20+y);
      Canvas.LineTo(i,23+y);
      Canvas.MoveTo(i,35+y);
      Canvas.LineTo(i,32+y);
      i:=i+10;
    end;
  end;
  Canvas.Pen.Color:=RGB(255,255,255);
  Canvas.MoveTo(0,26+y);
  Canvas.LineTo(128,26+y);
  Canvas.MoveTo(0,27+y);
  Canvas.LineTo(128,27+y);
  Canvas.MoveTo(0,28+y);
  Canvas.LineTo(128,28+y);
  Canvas.MoveTo(0,29+y);
  Canvas.LineTo(128,29+y);
  Canvas.MoveTo(0,30+y);
  Canvas.LineTo(128,30+y);
  if (ValorDetectat<ValorMinim) or (ValorDetectat>ValorMaxim) then Canvas.Pen.Color:=RGB(255,0,0) else Canvas.Pen.Color:=RGB(0,255,0);
  Canvas.MoveTo(0,26+y);
  Canvas.LineTo(ValorDetectat,26+y);
  Canvas.MoveTo(0,27+y);
  Canvas.LineTo(ValorDetectat,27+y);
  Canvas.MoveTo(0,28+y);
  Canvas.LineTo(ValorDetectat,28+y);
  Canvas.MoveTo(0,29+y);
  Canvas.LineTo(ValorDetectat,29+y);
  Canvas.MoveTo(0,30+y);
  Canvas.LineTo(ValorDetectat,30+y);
end;

procedure TFormXupaXups.CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
begin
  if CheckBoxLiniesAlMateixLLoc.Checked then PosicioSegonaLinia:=Panel.Height+128 else PosicioSegonaLinia:=Panel.Height+256;
  Repaint;
end;

procedure TFormXupaXups.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
  Repaint;
end;

procedure TFormXupaXups.SpeedButtonEngegarPararClick(Sender: TObject);
var
  i,n:integer;
begin
  if SpeedButtonEngegarParar.Down then begin
    HiHaXupaXups:=false;
    ComptadorPosicio:=0;
    SpeedButtonEngegarParar.Caption:='P';
    SpeedButtonEngegarPararGlobus.Enabled:=false;
    for i:=0 to MaximPosicionsViatge do for n:=0 to 1 do CircuitXupaXups[n,i]:=false;
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormXupaXups.SpeedButtonEngegarPararGlobusClick(Sender: TObject);
var
  i:integer;
begin
  if SpeedButtonEngegarPararGlobus.Down then begin
    HiHaXupaXups:=false;
    ComptadorPosicio:=0;
    SpeedButtonEngegarPararGlobus.Caption:='PG';
    SpeedButtonEngegarParar.Enabled:=false;
    for i:=0 to MaximPosicionsViatge do CircuitXupaXups[1,i]:=false;
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarParar.Enabled:=true;
  end;
end;

procedure TFormXupaXups.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
begin
  Repaint;
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  ValorDetectat:=Max;
  Canvas.Pen.Color:=clRed;
  Canvas.MoveTo(ComptadorPosicio,PosicioPrimeraLinia);
  Canvas.LineTo(ComptadorPosicio-6,PosicioPrimeraLinia-6);
  Canvas.LineTo(ComptadorPosicio-6,PosicioPrimeraLinia+6);
  Canvas.LineTo(ComptadorPosicio,PosicioPrimeraLinia);
  if SpeedButtonEngegarParar.Down then begin
    if (Max>=ValorMinim) and (Max<=ValorMaxim) then begin
      if not HiHaXupaXups then begin
        HiHaXupaXups:=true;
        CircuitXupaXups[0,ComptadorPosicio]:=true;
      end;
    end else HiHaXupaXups:=false;
  end else begin
    if (Max>=ValorMinim) and (Max<=ValorMaxim) then begin
      if not HiHaXupaXups then begin
        HiHaXupaXups:=true;
        CircuitXupaXups[1,ComptadorPosicio]:=true;
      end;
    end else HiHaXupaXups:=false;
    Canvas.MoveTo(ComptadorPosicio,PosicioSegonaLinia);
    Canvas.LineTo(ComptadorPosicio-6,PosicioSegonaLinia-6);
    Canvas.LineTo(ComptadorPosicio-6,PosicioSegonaLinia+6);
    Canvas.LineTo(ComptadorPosicio,PosicioSegonaLinia);
  end;
  ComptadorPosicio:=ComptadorPosicio+IncrementX;
  {
  if ComptadorPosicio<ClientWidth then begin
    Canvas.Pen.Color:=clBlue;
    Canvas.MoveTo(ComptadorPosicio,Panel.Height);
    Canvas.LineTo(ComptadorPosicio,ClientHeight);
  end;
  }
  if ComptadorPosicio+IncrementX>=ClientWidth then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end else EntradaSo;
end;


procedure TFormXupaXups.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

end.
